(* Content-type: application/vnd.wolfram.cdf.text *)

(*** Wolfram CDF File ***)
(* http://www.wolfram.com/cdf *)

(* CreatedBy='Mathematica 9.0' *)

(*************************************************************************)
(*                                                                       *)
(*  The Mathematica License under which this file was created prohibits  *)
(*  restricting third parties in receipt of this file from republishing  *)
(*  or redistributing it by any means, including but not limited to      *)
(*  rights management or terms of use, without the express consent of    *)
(*  Wolfram Research, Inc. For additional information concerning CDF     *)
(*  licensing and redistribution see:                                    *)
(*                                                                       *)
(*        www.wolfram.com/cdf/adopting-cdf/licensing-options.html        *)
(*                                                                       *)
(*************************************************************************)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[      1063,         20]
NotebookDataLength[    126079,       2937]
NotebookOptionsPosition[    121396,       2761]
NotebookOutlinePosition[    121983,       2785]
CellTagsIndexPosition[    121940,       2782]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
Freier Fall aus der Stratosph\[ADoubleDot]re (Christian Spreitzer, Juli 2013):\
\>", "Title"],

Cell[CellGroupData[{

Cell["\<\
Luftdichte als Funktion der H\[ODoubleDot]he in km (Daten aus US Standard \
Atmosphere 1976):\
\>", "Section"],

Cell[BoxData[
 RowBox[{"ddata", ":=", 
  StyleBox[
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1.225"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1.1117"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "1.0066"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "0.90925"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "0.81935"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "0.73643"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "0.66011"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "0.59002"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"8", ",", "0.52579"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"9", ",", "0.46706"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "0.41351"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"11", ",", "0.3648"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"12", ",", "0.31194"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"13", ",", "0.2666"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"14", ",", "0.22786"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"15", ",", "0.19476"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"16", ",", "0.16647"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"17", ",", "0.1423"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"18", ",", "0.12165"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"19", ",", "0.104"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"20", ",", "0.08891"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"21", ",", "0.075715"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"22", ",", "0.06451"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"23", ",", "0.055006"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"24", ",", "0.04938"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"25", ",", "0.040084"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"26", ",", "0.034257"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"27", ",", "0.029298"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"28", ",", "0.025076"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"29", ",", "0.021478"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"30", ",", "0.01841"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"31", ",", "0.015792"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"32", ",", "0.013555"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"33", ",", "0.011573"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"34", ",", "0.0098874"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"35", ",", "0.0084634"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"36", ",", "0.0072579"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"37", ",", "0.0062355"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"38", ",", "0.0053666"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"39", ",", "0.0046268"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"40", ",", "0.0039957"}], "}"}]}], "}"}], "Input"]}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", "ddata", "]"}]], "Input"],

Cell[BoxData[
 GraphicsBox[{{}, 
   {RGBColor[0.24720000000000014`, 0.24, 0.6], PointBox[CompressedData["
1:eJw1yV1IkwEYxfFlFw0vMiLCaFEtazpz02a29fUe92ptyYq5BiEIsVhgH9hk
E7oY03JE6mKYXuhFK5hgoCFppS/RYBgaUWQzrEHYPqQopNViUEGUeDrw8PDj
v93RXO/Mk8lkJf9u+f/fQP/yssKKMkJNU3PG/+wbLcNOT96AfHOGlsN37rH7
ZuESvQ5tpoh3i/4zvQEBx+Tgm+BHuhDpsxOrQlsXaQWGun0hVyJJb8Ov/Nfd
tbEPtBIR0Xr7RPo9XYT5pvDg99Y4vQtzpc5NyVPzdDGuKHrLY7kYrYah9mjL
z4JZejfy/XJ9h/oFrcG9mKlucWmGLof7a6IndfwpXYEyUfElWRWl98CSvWFz
F0VoHQzjM61PQhJdiYtB85GX0Yf0XtQXzH5a6xijq3B+TqyUro7S+zCaVm+M
lAzTepwpVsXtpru0AQtd2njKH6b3I+Wylik779AHoLM1+Opkt+iDCLuGFvwj
/fQhJLx2zck/ffRhPLgwol0f76EFTDSoNNOlQRq4vqbXMhntWnEbcHq1cqpv
7Bp7NfzTOxrfCh3s1ZBU41ajvZ3dCNuU7r5H8rIbIf3Qmp2dl9lFtOfePTL/
9rCLeGXJqQPZFvYaHBuuCDxvvCT8BSz5t3E=
     "]]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  Method->{},
  PlotRange->{{0, 40.}, {0, 1.225}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0.8, 0.8}, {0.0245, 0.0245}}]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Zum Vergleich: Exponentielle Abnahme der Luftdichte in einer Atmosph\
\[ADoubleDot]re konstanter Temperatur:\
\>", "Section"],

Cell[BoxData[
 RowBox[{
  RowBox[{"df", "[", "h_", "]"}], ":=", 
  RowBox[{"1.225", "*", 
   RowBox[{"Exp", "[", 
    RowBox[{
     RowBox[{"-", "h"}], "/", "8"}], "]"}]}]}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"df", "[", "h", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"h", ",", "0", ",", "40"}], "}"}], ",", 
   RowBox[{"Epilog", "\[Rule]", 
    RowBox[{"Map", "[", 
     RowBox[{"Point", ",", "ddata"}], "]"}]}]}], "]"}]], "Input"],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVxX0803kcAHCFuy7rSl1eJ9mGouYhVEri87FvRZ6u8tBFD2d56Ioe7fIi
5bd0Wk0oytNee8nhJErh2iUJR8Iu0wON1GY5TxVrGMrd/fF+vU04R3aEztbS
0vL+z/8LT3O+sgspduHe0IvOzFRBfTvTayeTD816yWv6U1Uw01B9lsnMhNRC
ltrpggqENUkMXWYRIP9D3ECMCiKcuZHjDDF8qrspOLRbBe1TB9I+Mppgm2Jv
xjRDBV/L5BbDjE6Iow167igahdwnomODjH7oygmvFNSPQOktvizCZhJU9jWb
lKMfIBzaMoeOa+OtM4QbNjwEh5UrFeWl3+Bzj6N3TV0GYK5JgkXP+gWY08HR
F+T0waUFzazcnxZhkXM2fTJECRyZ30PtFgN0Mq1Lf+eogGN/JXCOWCzBfDMt
l4of3kLZUZrv91uN8XeFwYRZaA/kxh4asN3JxGef3JZPOnUBTzS9/dOQCVos
DRjefLkTtNrfYFWMGVY/kb2LXPMSzKPCov1Yy9FkyM45QP4MetXXAvQemOP9
4dGI8mEpeCgPxl0+tgLnneyx6dBuA5/eFEs6nYU359+z2VoggYE6TvzjEktk
rfASvGppBhv9F8ZknzXK9wdUrZzdBHNBHdylssEP7WOJXwobwG04cNzU3xaJ
6813JKgeOmpDZgVa2eE/DT3SSN9aqDhfv5eptsOR6Pkf/YQ1EKbLfSOR2KPU
qSlf/uYB7D8eW0HLWo2KtY6rNn17H1aFW0q8gtfgrNKMC+aCe/D3Qis9ruNa
PPHYIfa2QSXcL+VlW2k74J1MjwB3nXKIncXa1tLtgEVPk6JOfC6DuV0x7ofL
1+Gui4/yHVffBmWBSZro1HoUNzr7z+GUQNoKQx2xvyPGTybX/xJ5A1KywhqD
mRvQuEe6mPaxEALT9khofRvQPm0w5Kw4HyY25WtE1U4o3UXUsqQ8UCjZ0bWJ
G7FX28w2S5wL153tjFqDndHHLLOu6LUISs5x9cOtXXCOl253+qscSPTf76mt
dkH50kyN0CoL1nblFiW2AubT2D8HC65BxsrsklZPxCX0yXVj/ulwpiYpw1OM
mBu3ZWCR1RXwNvLPf7LMFe0DZy8cZ6eC6+HGIH2+K0pm9iw/7Z0MoqWcZS1q
V3R+5DflaC6AZXWFV32C2BhsNNVoepoPKda1LGk1GwW9Ooa1JokQptJpa2IR
LL4nfmvVlgCcslEmP5mg6OG+6PZuHkTwfKc9UgkyDWNiLz7nAde3/CXtCkGF
hG7i1sqD82rupZSrBL3WFXg3VfGg1FEzdU1IMCHWamYimweaRzMvCooJWncH
cnSCeJAipSXVNxLU8OKgRkZBVl7kgV+bCPI7Bvn97RTkRUmIezPBzmLLzQYt
FFQapEw2SwgOji2eE1NFQVfgogPtzwk+3c1NPyikwEJhSOQKgn/YXDjzfh8F
tuUx9N+UBBeKt5j5/EjBhnMyTWgfwYoyDaNsGwVeFsLb/QMEtcc5dMqVguOH
mPSREYLnGW5fbTWj4NRGSnNHRTBWXuleZ0TBuXnyZ1Fqgu9fRXbgdxRk3Mq7
ODFBUD2m7NysS8H1eJ3wPycJVo3Vurd+jofi7aHsU9MEXyvoMzvH4qHctMHY
5QtBGps/pXwfD9Uqc83MDMG7Dpc3nuyLh38B9dlPzw==
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  Epilog->{
    PointBox[{0, 1.225}], 
    PointBox[{1, 1.1117}], 
    PointBox[{2, 1.0066}], 
    PointBox[{3, 0.90925}], 
    PointBox[{4, 0.81935}], 
    PointBox[{5, 0.73643}], 
    PointBox[{6, 0.66011}], 
    PointBox[{7, 0.59002}], 
    PointBox[{8, 0.52579}], 
    PointBox[{9, 0.46706}], 
    PointBox[{10, 0.41351}], 
    PointBox[{11, 0.3648}], 
    PointBox[{12, 0.31194}], 
    PointBox[{13, 0.2666}], 
    PointBox[{14, 0.22786}], 
    PointBox[{15, 0.19476}], 
    PointBox[{16, 0.16647}], 
    PointBox[{17, 0.1423}], 
    PointBox[{18, 0.12165}], 
    PointBox[{19, 0.104}], 
    PointBox[{20, 0.08891}], 
    PointBox[{21, 0.075715}], 
    PointBox[{22, 0.06451}], 
    PointBox[{23, 0.055006}], 
    PointBox[{24, 0.04938}], 
    PointBox[{25, 0.040084}], 
    PointBox[{26, 0.034257}], 
    PointBox[{27, 0.029298}], 
    PointBox[{28, 0.025076}], 
    PointBox[{29, 0.021478}], 
    PointBox[{30, 0.01841}], 
    PointBox[{31, 0.015792}], 
    PointBox[{32, 0.013555}], 
    PointBox[{33, 0.011573}], 
    PointBox[{34, 0.0098874}], 
    PointBox[{35, 0.0084634}], 
    PointBox[{36, 0.0072579}], 
    PointBox[{37, 0.0062355}], 
    PointBox[{38, 0.0053666}], 
    PointBox[{39, 0.0046268}], 
    PointBox[{40, 0.0039957}]},
  Method->{},
  PlotRange->{{0, 40}, {0., 1.2249998750000064`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Interpolation der Atmosph\[ADoubleDot]rendichtedaten:\
\>", "Section"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dint", "=", 
  RowBox[{"Interpolation", "[", "ddata", "]"}]}]], "Input"],

Cell[BoxData[
 TagBox[
  RowBox[{"InterpolatingFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "40.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"dint", "[", "h", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"h", ",", "0", ",", "40"}], "}"}], ",", 
   RowBox[{"Epilog", "\[Rule]", 
    RowBox[{"Map", "[", 
     RowBox[{"Point", ",", "ddata"}], "]"}]}]}], "]"}]], "Input"],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVUXk41I0a9UUq0ZeUyjKEKKR81e83I7wvv1xCCz7plha7S5ixRHFTlKU+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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  Epilog->{
    PointBox[{0, 1.225}], 
    PointBox[{1, 1.1117}], 
    PointBox[{2, 1.0066}], 
    PointBox[{3, 0.90925}], 
    PointBox[{4, 0.81935}], 
    PointBox[{5, 0.73643}], 
    PointBox[{6, 0.66011}], 
    PointBox[{7, 0.59002}], 
    PointBox[{8, 0.52579}], 
    PointBox[{9, 0.46706}], 
    PointBox[{10, 0.41351}], 
    PointBox[{11, 0.3648}], 
    PointBox[{12, 0.31194}], 
    PointBox[{13, 0.2666}], 
    PointBox[{14, 0.22786}], 
    PointBox[{15, 0.19476}], 
    PointBox[{16, 0.16647}], 
    PointBox[{17, 0.1423}], 
    PointBox[{18, 0.12165}], 
    PointBox[{19, 0.104}], 
    PointBox[{20, 0.08891}], 
    PointBox[{21, 0.075715}], 
    PointBox[{22, 0.06451}], 
    PointBox[{23, 0.055006}], 
    PointBox[{24, 0.04938}], 
    PointBox[{25, 0.040084}], 
    PointBox[{26, 0.034257}], 
    PointBox[{27, 0.029298}], 
    PointBox[{28, 0.025076}], 
    PointBox[{29, 0.021478}], 
    PointBox[{30, 0.01841}], 
    PointBox[{31, 0.015792}], 
    PointBox[{32, 0.013555}], 
    PointBox[{33, 0.011573}], 
    PointBox[{34, 0.0098874}], 
    PointBox[{35, 0.0084634}], 
    PointBox[{36, 0.0072579}], 
    PointBox[{37, 0.0062355}], 
    PointBox[{38, 0.0053666}], 
    PointBox[{39, 0.0046268}], 
    PointBox[{40, 0.0039957}]},
  Method->{},
  PlotRange->{{0, 40}, {0., 1.2249999040408193`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Schallgeschwindigkeit als Funktion der H\[ODoubleDot]he in km (Daten aus US \
Standard Atmosphere 1976):\
\>", "Section"],

Cell[BoxData[
 RowBox[{"sdata", ":=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "340.29"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "336.43"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "332.53"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "328.58"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "324.59"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "320.55"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"6", ",", "316.45"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"7", ",", "312.31"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"8", ",", "308.11"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"9", ",", "303.85"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"10", ",", "299.53"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"11", ",", "295.15"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"12", ",", "295.07"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"13", ",", "295.07"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"14", ",", "295.07"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"15", ",", "295.07"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"16", ",", "295.07"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"17", ",", "295.07"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"18", ",", "295.07"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"19", ",", "295.07"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"20", ",", "295.07"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"21", ",", "295.7"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"22", ",", "296.38"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"23", ",", "297.05"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"24", ",", "297.72"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"25", ",", "298.39"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"26", ",", "299.06"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"27", ",", "299.72"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"28", ",", "300.39"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"29", ",", "301.05"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"30", ",", "301.71"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"31", ",", "302.37"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"32", ",", "303.02"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"33", ",", "304.67"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"34", ",", "306.49"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"35", ",", "308.3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"36", ",", "310.1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"37", ",", "311.89"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"38", ",", "313.67"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"39", ",", "315.43"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"40", ",", "317.19"}], "}"}]}], "}"}]}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sint", "=", 
  RowBox[{"Interpolation", "[", "sdata", "]"}]}]], "Input"],

Cell[BoxData[
 TagBox[
  RowBox[{"InterpolatingFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "40.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"sint", "[", "h", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"h", ",", "0", ",", "40"}], "}"}], ",", 
   RowBox[{"Epilog", "\[Rule]", 
    RowBox[{"Map", "[", 
     RowBox[{"Point", ",", "sdata"}], "]"}]}]}], "]"}]], "Input"],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxF13k8VN0bAHDZKktJC0kozCKEO8k+jwZFJFmiSJQt+x0TWSqiopRKZCeU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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{None, None},
  AxesOrigin->{0, 294.},
  Epilog->{
    PointBox[{0, 340.29}], 
    PointBox[{1, 336.43}], 
    PointBox[{2, 332.53}], 
    PointBox[{3, 328.58}], 
    PointBox[{4, 324.59}], 
    PointBox[{5, 320.55}], 
    PointBox[{6, 316.45}], 
    PointBox[{7, 312.31}], 
    PointBox[{8, 308.11}], 
    PointBox[{9, 303.85}], 
    PointBox[{10, 299.53}], 
    PointBox[{11, 295.15}], 
    PointBox[{12, 295.07}], 
    PointBox[{13, 295.07}], 
    PointBox[{14, 295.07}], 
    PointBox[{15, 295.07}], 
    PointBox[{16, 295.07}], 
    PointBox[{17, 295.07}], 
    PointBox[{18, 295.07}], 
    PointBox[{19, 295.07}], 
    PointBox[{20, 295.07}], 
    PointBox[{21, 295.7}], 
    PointBox[{22, 296.38}], 
    PointBox[{23, 297.05}], 
    PointBox[{24, 297.72}], 
    PointBox[{25, 298.39}], 
    PointBox[{26, 299.06}], 
    PointBox[{27, 299.72}], 
    PointBox[{28, 300.39}], 
    PointBox[{29, 301.05}], 
    PointBox[{30, 301.71}], 
    PointBox[{31, 302.37}], 
    PointBox[{32, 303.02}], 
    PointBox[{33, 304.67}], 
    PointBox[{34, 306.49}], 
    PointBox[{35, 308.3}], 
    PointBox[{36, 310.1}], 
    PointBox[{37, 311.89}], 
    PointBox[{38, 313.67}], 
    PointBox[{39, 315.43}], 
    PointBox[{40, 317.19}]},
  Method->{},
  PlotRange->{{0, 40}, {294.83423296450104`, 340.28999686258504`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output"]
}, Open  ]]
}, Open  ]],

Cell["\<\
Str\[ODoubleDot]mungswiderstandsbeiwert als Funktion der Machzahl (Daten aus \
Jandir et al.):\
\>", "Section"],

Cell[CellGroupData[{

Cell["Drag coefficient as a function of Mach number for a sphere:", \
"Subsubtitle"],

Cell[BoxData[
 RowBox[{
  RowBox[{"DS", "[", "m_", "]"}], ":=", 
  RowBox[{"Piecewise", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"0.45", "*", 
         RowBox[{"m", "^", "2"}]}], "+", "0.424"}], ",", 
       RowBox[{"m", "<", "0.722"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"2.1", "*", 
         RowBox[{"Exp", "[", 
          RowBox[{
           RowBox[{"-", "1.2"}], "*", 
           RowBox[{"(", 
            RowBox[{"m", "+", "0.35"}], ")"}]}], "]"}]}], "-", 
        RowBox[{"8.9", "*", 
         RowBox[{"Exp", "[", 
          RowBox[{
           RowBox[{"-", "2.2"}], "*", 
           RowBox[{"(", 
            RowBox[{"m", "+", "0.35"}], ")"}]}], "]"}]}], "+", "0.92"}], ",", 
       
       RowBox[{"m", "\[GreaterEqual]", "0.722"}]}], "}"}]}], "}"}], 
   "]"}]}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"DS", "[", "m", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", "0", ",", "3"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxl1Hk4lHsfBnBbiEr26nRMyCBHvUnlVNySiGwlXkkaWd4sUa7TWLMl1TTI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      "]], 
     LineBox[CompressedData["
1:eJwV13c81V8YB3ArVygVSUiyEi2rEH1uIqWShlFJheRHSWUTKspokJGRFClF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      "]]}, {}}, {{}, {}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{None, None},
  AxesOrigin->{0, 0.42},
  Method->{},
  PlotRange->{{0, 3}, {0.42400000000000165`, 1.0015270996479535`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DS", "[", "0", "]"}]], "Input"],

Cell[BoxData["0.424`"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Dimensionless function modeling the flat spin period of F. B. (Funktion \
anhand Videoaufnahmen des Sprungs modelliert):\
\>", "Section"],

Cell[BoxData[
 RowBox[{
  RowBox[{"FSRR", "[", "r_", "]"}], ":=", 
  RowBox[{"Piecewise", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"r", "<", "50"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"r", "-", "50"}], ")"}], "/", "15"}]}], ",", 
       RowBox[{"50", "\[LessEqual]", "r", "<", "65"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", 
       RowBox[{"55", "\[LessEqual]", "r"}]}], "}"}]}], "}"}], 
   "]"}]}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"FSRR", "[", "t", "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"t", ",", " ", "10", ",", " ", "100"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxTTMoPSmViYGCQAWIQ7Ze30JaBQcWBAQw+2Kd9PrvG7ogqnF9X8Uu6tkMd
zs/YuW8uX6w2nL9yc6vY0g96cH7bicf3lSwN4fypQVZtf+WN4fwAS6EVUc9M
EObtni996JIZnC+4Pmu53jYLhHv+b1snW2kF50u83sEunmQD55ca29yZpGUH
5ye9/XNC+JU9nB++cGfz+ecOcH5Q1daEsFOOcP4fhZ60R/ud4Pz8hsYfHzY4
w/nmfeYnDkx0gfPXZZ44MLXVFc6v+iz5XTvTDc7/6uUWdjzeHc63jJ7o+DTQ
A85/4HWFO7YLwW+zEr925RCCH7nJYrfAfQRfRytqgc9vBH/PnKbpwX8QfAAP
kIf/
      "]], LineBox[CompressedData["
1:eJwBAQP+/CFib1JlAgAAAC8AAAACAAAARGN9aKwDSUCisT401gfwPxy3Rhbj
BUlA1bl0Ho8M8D8W5uqSaglJQNrqwY4WFPA/EBWPD/IMSUDeGw//nRvwPwpE
M4x5EElA4kxcbyUj8D//oXuFiBdJQO2u9k80MvA/+tAfAhAbSUDz30PAuznw
P/T/w36XHklA9xCRMENB8D/oXQx4piVJQABzKxFSUPA/0hmdasQzSUAVN2DS
b27wPwO05PuXN0lAXNXWkJl28D80TiyNaztJQKJzTU/DfvA/loK7rxJDSUAv
sDrMFo/wP1vr2fRgUklASykVxr2v8D/kvBZ//XBJQIAbyrkL8fA/9l+Qkzau
SUDr/zOhp3PxPxqmg7yoKEpAwMgHcN948j+44CpMTg1LQIgB5AinYPQ/HtTw
Z3btS0DaGVd32j72PzOVkayj4ExAj4IlcKFF+D+dBPMuksNNQGCSKGTAKfo/
tkEv2oW5TkCW8obicjb8P5g3ihH8qk9AVjJ8NpE5/j8ppl7vgK5PQPHZuA8T
Qf4/uhQzzQWyT0CMgfXolEj+P9zx24gPuU9AxNBum5hX/j8frC0AI8dPQDFv
YQCgdf4/piDR7knjT0AMrEbKrrH+P9oEDObLDVBAxCURXswp/z8iPPZUjg9Q
QF7NTTdOMf8/a3Pgw1ARUED8dIoQ0Dj/P/zhtKHVFFBAM8QDw9NH/z8dv11d
3xtQQJ5i9ifbZf8/ZvZHzKEdUEA8CjMBXW3/P64tMjtkH1BA1rFv2t50/z8+
nAYZ6SJQQAgB6Yzig/8/YHmv1PIpUEB4n9vx6aH/P6iwmUO1K1BAEUcYy2up
/z/x54Oydy1QQK/uVKTtsP8/glZYkPwwUEDmPc5W8b//P8qNQv++MlBAgOUK
MHPH/z8TxSxugTRQQB6NRwn1zv8/pDMBTAY4UEBW3MC7+N3/P+xq67rIOVBA
74P9lHrl/z81otUpiztQQIwrOm787P8/ftm/mE09UEAq03ZHfvT/P15Owcsp
PlBAXk7Byyn4/z/RL2nU
      "]], LineBox[CompressedData["
1:eJxTTMoPSmViYGCQBGIQvWijnck1xwAHBghwCKuvezrFCcGfty0jJNwFwX/+
NuiwpBuCn9B14ZVGM4J/U81PyOIAgv9tmyaDuVEgnF+xWMTk+0IE/+K3nD+W
0kFwfujCpcmxPQj+hk3e8czswXC+mfSln52VCL7Cg/RbF18i+A+5s/3nJIfA
+Wf7/JLdryL4Eyvmc5cGhML5O/f9/5l8EsHniXFoN7YKQ9iX8G5F6xYEv3t3
TeYOtXA436VYqmDNNAT/ykRVbmWBCDi/n13QtaoRwX+Us05u7wEE3+yS94//
/xF8AGWJX8M=
      "]]}, {}}, {{}, {}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{None, None},
  AxesOrigin->{20., 1.},
  Method->{},
  PlotRange->{{10, 100}, {1., 2.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Erdbeschleunigung in gro\[SZ]er H\[ODoubleDot]he:\
\>", "Section"],

Cell[BoxData[
 RowBox[{
  RowBox[{"greal", "[", "h_", "]"}], ":=", 
  RowBox[{"9.80665", "*", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"6371000", "/", 
      RowBox[{"(", 
       RowBox[{"6371000", "+", "h"}], ")"}]}], ")"}], "^", "2"}]}]}]], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Kalibrierung des Modells im Geschwindigkeitsmaximum:", "Section"],

Cell[BoxData[
 RowBox[{"hkal", ":=", "27833"}]], "Input"],

Cell[BoxData[
 RowBox[{"vkal", ":=", 
  RowBox[{"1357.6", "/", "3.6"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"b1", ":=", 
  RowBox[{
   RowBox[{"greal", "[", "hkal", "]"}], "/", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"df", "[", 
      RowBox[{"hkal", "/", "1000"}], "]"}], "*", 
     RowBox[{"vkal", "^", "2"}]}], ")"}]}]}]], "Input"],

Cell[BoxData[
 RowBox[{"b2", ":=", 
  RowBox[{
   RowBox[{"greal", "[", "hkal", "]"}], "/", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"dint", "[", 
      RowBox[{"hkal", "/", "1000"}], "]"}], "*", 
     RowBox[{"vkal", "^", "2"}]}], ")"}]}]}]], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Originale Daten vom Stratosph\[ADoubleDot]rensprung:\
\>", "Section"],

Cell[CellGroupData[{

Cell["Zeit-Geschwindigkeit:", "Subsubsection"],

Cell[BoxData[
 RowBox[{"speeddata", ":=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"34", ",", 
      RowBox[{"1115", "/", "3.6"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"50", ",", 
      RowBox[{"1357.6", "/", "3.6"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"64", ",", 
      RowBox[{"1043", "/", "3.6"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"180", ",", 
      RowBox[{"285", "/", "3.6"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"260", ",", 
      RowBox[{"191.5", "/", "3.6"}]}], "}"}]}], "}"}]}]], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Zeit-H\[ODoubleDot]he:", "Subsubsection"],

Cell[BoxData[
 RowBox[{"heightdata", ":=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"34", ",", "33446"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"50", ",", "27833"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"64", ",", "22960.7"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"180", ",", "7619"}], "}"}]}], "}"}]}]], "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Differentialgleichung und numerische L\[ODoubleDot]sung (Geschwindigkeit in \
m/s vs. Zeit in s) mit expontiell abnehmender Luftdichte:\
\>", "Section"],

Cell[BoxData[
 RowBox[{
  RowBox[{"s1", ":=", 
   RowBox[{"NDSolve", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"h", "''"}], "[", "t", "]"}], "\[Equal]", 
        RowBox[{
         RowBox[{"-", 
          RowBox[{"greal", "[", 
           RowBox[{"h", "[", "t", "]"}], "]"}]}], "+", 
         RowBox[{
          RowBox[{"df", "[", 
           RowBox[{
            RowBox[{"h", "[", "t", "]"}], "/", "1000"}], "]"}], "*", 
          RowBox[{
           RowBox[{"h", "'"}], "[", "t", "]"}], "*", 
          RowBox[{
           RowBox[{"h", "'"}], "[", "t", "]"}], "*", "b1"}]}]}], ",", 
       RowBox[{
        RowBox[{"h", "[", "0", "]"}], "\[Equal]", "38969"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"h", "'"}], "[", "0", "]"}], "==", "0"}]}], "}"}], ",", "h", 
     ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "1000"}], "}"}]}], "]"}]}], ";"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       RowBox[{"h", "'"}], "[", "t", "]"}]}], "/.", "s1"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "300"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"Epilog", "\[Rule]", 
    RowBox[{"Map", "[", 
     RowBox[{"Point", ",", "speeddata"}], "]"}]}]}], "]"}]], "Input"],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVl3k0ld0Xx5OKJG+pVDJEhgyvipJK19d4731wQ5mHklmE63oa0CDzLENI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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  Epilog->{
    PointBox[{34, 309.72222222222223`}], 
    PointBox[{50, 377.1111111111111}], 
    PointBox[{64, 289.72222222222223`}], 
    PointBox[{180, 79.16666666666667}], 
    PointBox[{260, 53.19444444444445}]},
  Method->{},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Differentialgleichung und numerische L\[ODoubleDot]sung  (Geschwindigkeit in \
m/s vs. Zeit in s) mit dem Modell der US Standard Atmosphere:\
\>", "Section"],

Cell[BoxData[
 RowBox[{
  RowBox[{"s2", ":=", 
   RowBox[{"NDSolve", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"h", "''"}], "[", "t", "]"}], "\[Equal]", 
        RowBox[{
         RowBox[{"-", 
          RowBox[{"greal", "[", 
           RowBox[{"h", "[", "t", "]"}], "]"}]}], "+", 
         RowBox[{
          RowBox[{"dint", "[", 
           RowBox[{
            RowBox[{"h", "[", "t", "]"}], "/", "1000"}], "]"}], "*", 
          RowBox[{
           RowBox[{"h", "'"}], "[", "t", "]"}], "*", 
          RowBox[{
           RowBox[{"h", "'"}], "[", "t", "]"}], "*", "b2"}]}]}], ",", 
       RowBox[{
        RowBox[{"h", "[", "0", "]"}], "\[Equal]", "38969"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"h", "'"}], "[", "0", "]"}], "==", "0"}]}], "}"}], ",", "h", 
     ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "1000"}], "}"}]}], "]"}]}], ";"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       RowBox[{"h", "'"}], "[", "t", "]"}]}], "/.", "s2"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "300"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"Epilog", "\[Rule]", 
    RowBox[{"Map", "[", 
     RowBox[{"Point", ",", "speeddata"}], "]"}]}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"InterpolatingFunction", "::", "dmval"}], "MessageName"], ":", 
  " ", "\<\"Input value \[NoBreak]\\!\\({\\(-0.12294669090656213`\\)}\\)\
\[NoBreak] lies outside the range of data in the interpolating function. \
Extrapolation will be used. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/InterpolatingFunction/dmval\\\", \
ButtonNote -> \\\"InterpolatingFunction::dmval\\\"]\\)\"\>"}]], "Message", \
"MSG"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"InterpolatingFunction", "::", "dmval"}], "MessageName"], ":", 
  " ", "\<\"Input value \[NoBreak]\\!\\({\\(-0.12294671251169864`\\)}\\)\
\[NoBreak] lies outside the range of data in the interpolating function. \
Extrapolation will be used. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/InterpolatingFunction/dmval\\\", \
ButtonNote -> \\\"InterpolatingFunction::dmval\\\"]\\)\"\>"}]], "Message", \
"MSG"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"InterpolatingFunction", "::", "dmval"}], "MessageName"], ":", 
  " ", "\<\"Input value \[NoBreak]\\!\\({\\(-0.12294670843715887`\\)}\\)\
\[NoBreak] lies outside the range of data in the interpolating function. \
Extrapolation will be used. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/InterpolatingFunction/dmval\\\", \
ButtonNote -> \\\"InterpolatingFunction::dmval\\\"]\\)\"\>"}]], "Message", \
"MSG"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], ":", 
  " ", "\<\"Further output of \
\[NoBreak]\\!\\(\\*StyleBox[\\(InterpolatingFunction :: dmval\\), \
\\\"MessageName\\\"]\\)\[NoBreak] will be suppressed during this calculation. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/stop\\\", \
ButtonNote -> \\\"General::stop\\\"]\\)\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVlnc8VX8YxyllJL+SqIwiGpSiH2ngY95hZF7ca9xrZK/bHUUoo7Izk5BV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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  Epilog->{
    PointBox[{34, 309.72222222222223`}], 
    PointBox[{50, 377.1111111111111}], 
    PointBox[{64, 289.72222222222223`}], 
    PointBox[{180, 79.16666666666667}], 
    PointBox[{260, 53.19444444444445}]},
  Method->{},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"%58", ",", 
   RowBox[{"ImageSize", "\[Rule]", "Full"}]}], "]"}]], "Input",
 NumberMarks->False],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVlnc8VX8YxyllJL+SqIwiGpSiH2ngY95hZF7ca9xrZK/bHUUoo7Izk5BV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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  Epilog->{
    PointBox[{34, 309.72222222222223`}], 
    PointBox[{50, 377.1111111111111}], 
    PointBox[{64, 289.72222222222223`}], 
    PointBox[{180, 79.16666666666667}], 
    PointBox[{260, 53.19444444444445}]},
  ImageSize->Full,
  Method->{},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Differentialgleichung und numerische L\[ODoubleDot]sung mit dem Modell der US \
Standard Atmosphere und Ber\[UDoubleDot]cksichtigung der Schallbarriere:\
\>", "Section"],

Cell[BoxData[
 RowBox[{
  RowBox[{"s3", ":=", 
   RowBox[{"NDSolve", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"h", "''"}], "[", "t", "]"}], "\[Equal]", 
        RowBox[{
         RowBox[{"-", 
          RowBox[{"greal", "[", 
           RowBox[{"h", "[", "t", "]"}], "]"}]}], "+", 
         RowBox[{
          RowBox[{"dint", "[", 
           RowBox[{
            RowBox[{"h", "[", "t", "]"}], "/", "1000"}], "]"}], "*", 
          RowBox[{
           RowBox[{"h", "'"}], "[", "t", "]"}], "*", 
          RowBox[{
           RowBox[{"h", "'"}], "[", "t", "]"}], "*", "b2", "*", 
          RowBox[{"DS", "[", 
           RowBox[{
            RowBox[{"Abs", "[", 
             RowBox[{
              RowBox[{"h", "'"}], "[", "t", "]"}], "]"}], "/", 
            RowBox[{"sint", "[", 
             RowBox[{
              RowBox[{"h", "[", "t", "]"}], "/", "1000"}], "]"}]}], 
           "]"}]}]}]}], ",", 
       RowBox[{
        RowBox[{"h", "[", "0", "]"}], "\[Equal]", "38969"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"h", "'"}], "[", "0", "]"}], "==", "0"}]}], "}"}], ",", "h", 
     ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "1000"}], "}"}]}], "]"}]}], ";"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       RowBox[{"h", "'"}], "[", "t", "]"}]}], "/.", "s3"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "300"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"Epilog", "\[Rule]", 
    RowBox[{"Map", "[", 
     RowBox[{"Point", ",", "speeddata"}], "]"}]}]}], "]"}]], "Input",
 NumberMarks->False],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"InterpolatingFunction", "::", "dmval"}], "MessageName"], ":", 
  " ", "\<\"Input value \[NoBreak]\\!\\({\\(-0.012324891821328492`\\)}\\)\
\[NoBreak] lies outside the range of data in the interpolating function. \
Extrapolation will be used. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/InterpolatingFunction/dmval\\\", \
ButtonNote -> \\\"InterpolatingFunction::dmval\\\"]\\)\"\>"}]], "Message", \
"MSG"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"InterpolatingFunction", "::", "dmval"}], "MessageName"], ":", 
  " ", "\<\"Input value \[NoBreak]\\!\\({\\(-0.012324891821328492`\\)}\\)\
\[NoBreak] lies outside the range of data in the interpolating function. \
Extrapolation will be used. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/InterpolatingFunction/dmval\\\", \
ButtonNote -> \\\"InterpolatingFunction::dmval\\\"]\\)\"\>"}]], "Message", \
"MSG"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"InterpolatingFunction", "::", "dmval"}], "MessageName"], ":", 
  " ", "\<\"Input value \[NoBreak]\\!\\({\\(-0.012324891821328492`\\)}\\)\
\[NoBreak] lies outside the range of data in the interpolating function. \
Extrapolation will be used. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/InterpolatingFunction/dmval\\\", \
ButtonNote -> \\\"InterpolatingFunction::dmval\\\"]\\)\"\>"}]], "Message", \
"MSG"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], ":", 
  " ", "\<\"Further output of \
\[NoBreak]\\!\\(\\*StyleBox[\\(InterpolatingFunction :: dmval\\), \
\\\"MessageName\\\"]\\)\[NoBreak] will be suppressed during this calculation. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/stop\\\", \
ButtonNote -> \\\"General::stop\\\"]\\)\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVlHc81e0bx5GQUGQ9yXwqirQoSnzMM6xjbzpHstfhnG+FklVk7wohmkSl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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  Epilog->{
    PointBox[{34, 309.72222222222223`}], 
    PointBox[{50, 377.1111111111111}], 
    PointBox[{64, 289.72222222222223`}], 
    PointBox[{180, 79.16666666666667}], 
    PointBox[{260, 53.19444444444445}]},
  Method->{},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"%42", ",", 
   RowBox[{"ImageSize", "\[Rule]", "Full"}]}], "]"}]], "Input",
 NumberMarks->False],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVlHc81e0bx5GQUGQ9yXwqirQoSnzMM6xjbzpHstfhnG+FklVk7wohmkSl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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  Epilog->{
    PointBox[{34, 309.72222222222223`}], 
    PointBox[{50, 377.1111111111111}], 
    PointBox[{64, 289.72222222222223`}], 
    PointBox[{180, 79.16666666666667}], 
    PointBox[{260, 53.19444444444445}]},
  ImageSize->Full,
  Method->{},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
HIER WURDE (ABGESEHEN VON DER KALIBRIERUNG DES WIDERSTANDSBEIWERTS IM \
GESCHWINDIGKEITSMAXIMUM) KEINERLEI PARAMETER ANGEPASST - DIES IST DIE \
THEORETISCH VORHERGESAGTE KURVE (BEI UNVER\[CapitalADoubleDot]NDERTER K\
\[CapitalODoubleDot]RPERHALTUNG W\[CapitalADoubleDot]HREND DES SPRUNGS, SO \
WIE BEIM GESCHWINDIGKEITSMAXIMUM).\
\>", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"h", "[", "t", "]"}], "/.", "s3"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "300"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"Epilog", "\[Rule]", 
    RowBox[{"Map", "[", 
     RowBox[{"Point", ",", "heightdata"}], "]"}]}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"InterpolatingFunction", "::", "dmval"}], "MessageName"], ":", 
  " ", "\<\"Input value \[NoBreak]\\!\\({\\(-0.012324891821328492`\\)}\\)\
\[NoBreak] lies outside the range of data in the interpolating function. \
Extrapolation will be used. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/InterpolatingFunction/dmval\\\", \
ButtonNote -> \\\"InterpolatingFunction::dmval\\\"]\\)\"\>"}]], "Message", \
"MSG"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"InterpolatingFunction", "::", "dmval"}], "MessageName"], ":", 
  " ", "\<\"Input value \[NoBreak]\\!\\({\\(-0.012324891821328492`\\)}\\)\
\[NoBreak] lies outside the range of data in the interpolating function. \
Extrapolation will be used. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/InterpolatingFunction/dmval\\\", \
ButtonNote -> \\\"InterpolatingFunction::dmval\\\"]\\)\"\>"}]], "Message", \
"MSG"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"InterpolatingFunction", "::", "dmval"}], "MessageName"], ":", 
  " ", "\<\"Input value \[NoBreak]\\!\\({\\(-0.012324891821328492`\\)}\\)\
\[NoBreak] lies outside the range of data in the interpolating function. \
Extrapolation will be used. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/InterpolatingFunction/dmval\\\", \
ButtonNote -> \\\"InterpolatingFunction::dmval\\\"]\\)\"\>"}]], "Message", \
"MSG"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], ":", 
  " ", "\<\"Further output of \
\[NoBreak]\\!\\(\\*StyleBox[\\(InterpolatingFunction :: dmval\\), \
\\\"MessageName\\\"]\\)\[NoBreak] will be suppressed during this calculation. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/stop\\\", \
ButtonNote -> \\\"General::stop\\\"]\\)\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV0Hk01Ykbx3GyVCpRYoYsUZZkiehSc7+fiSRKGaWQrbSQ5rqX0WLNkiQ3
oUWplC37eq9jiS8mbYgmJEvXFy1SJCFZft/fH895zuuc9/PPs+Yw66+jC4SE
hG7S8/9dYj/z40teJ5M3Pz+vvLAf0Q0uHbbcMuJem3ihEu24t2EBStwnxMuJ
gkp52l81c8QuZbcSL6yFNsjQThxIbBLldhAf2/+ZkaBtmhJ8LYTdQ0zLSevM
i/djVKdUNyi7j9AsffVolHb9kqx40+QBIudhZf472tc/3ZmYjP1AODxomn9B
2/NJvCMvZIjozF5cxKO9NT2qmsP+QgiZ+9Ql0774J1P65sZRQvBDeNN52uxC
Rr1/9jfiv+4asSO0HZUN/9mv9p2YMcrdvI22OVdHY1PyOCGt9fyZEm05b9WY
b7GTBGtTqmSLWD+Eulb/0SL+k/jxzq02jfbQTrmR/JBpwi7H/rU/7SqNpXbe
7FlCWXlSfiXtjOviYtZDc0R5YpZNj2g/noaFdiVuFIL67vtUGu2ib+difbOF
Eafoqb2BtrrWmffUsQX42MwUfBbpxy23f4i/1ESgbXzsx0PaES9Z3/STRcH9
WQUF2gfyPPZ/jV2IS2NDTgLhfjQOuOc7Wy3CidbqlTG0sdp1YZP4YgT/Ettg
SHt9jEN5TogE7LREggOE+jFzwkbRk70Mpjr7Hg7PUWCnWPu/0ZHEkzBHjzDa
7zssX+4YkkRhptD5VbRPpN5HwkYp7DCz6DacpWC7InmMnS0NZglbwfYXhaX5
8veyFq1A1IR+T+s0hYadSdZ9x1bA7XvD/B7apuevp+1VW4nohGvHzX9SWDsa
Z6+XLIN6w7t1yyYpTDZFVgzHykHXaipPdYyCByHBkB6Xg0XkHY2T3yi8KuTy
jBx/w5uf8rGFoxTyE24UBqv/jl/GbQoGI3TvkJUhVSOPh4odO6WG6X6gMX7T
qCLm5N1+MAYpwN5WysFeCeTNCMO9A/T9k7bYoColNEoHuXj0U4jO7r3YcFEZ
tTzDgPA+CiqMM0RunApKnF+2JvdQ6JiNNmJqqcJb/p7Y1jYKXONdfnsPqeJ9
oau86msK5izJksNXVCH13kxR7D8KxYJ4/agfqrjztuNLbQvd19/WbqlVQ8n9
T1WyjRS2R+etOey4DnUv57R06iiUyLQuuxCjiSWTRdKSuRSq2AoDRpWa8Cqu
Op6TTeHf5qMVg0OaaM8TkrHIotB+cfrYdistHF3EZ/lmUJiaUSNFF69H2dUz
m/NTKDAH/TnhF7TxAZ/V0xIpPOet7gg9r4vMpdLX4s/R/1lxPE+/SBcxkYrT
b89Q6GIVhQsEurh72qNC5TSFYS0LfUAP7HMndqf5Ulh+lxU9P6cH93W9dTHe
FNab9SkS1fqQeuQr3+1MwUd7U8ujLQYQF6uWj2BS6N28Y17RzgDBrrn3w7ZS
2G3uqBvsZYCc9X7pwab0vXPoZWaSAQqic9ayjCkMchstayYM4BeRs9hAl4Lj
mEctWWSIa2kXCglFCmbl14rrNYygsHyoIvBnH2R3TCY+W8nAQ/OkNwnZfRh7
aj21VoeBuJlQ78rMPjRZpTiFWjAAtXptQVofImx2qm4+y0BtdJbemnt0v/92
QVovA+J/jx49n0D3HsTzkCwTFKt6HKoMoPuwqHkjYgv2Jhn5rrbqw/dHcl4P
vJiQbIsjXvcKMGWrn7QrjInGX1puMV0CzAxaPp1IYuLk5pBdeCOAqOQ5detn
TIx7XolNbRVA1qWb+q5BwC7BqH3PvwIw5lKctg8SaLGTLkaWAITyNfXxAiBx
WWR+LFuASFel326s3wZ26JCl69Q75Ma6hpu5bkd59VupwKYeKJw95D0VYQm1
zHPOCRFdyMzqarrgZ419WRK1LKdONEdFlwWk2uDDNG+6bnUHLrV1L13XvBdf
TJTnfhm2oeXxq0Aps78QZOBjYR31HwaWCvQLOuywI0Z2Rv1zK6L8de+b2u6H
1LbOprvxLZg0Ttx/dsgeA1Sy6obAZixp77DcGngQfnKRy1fINiL/xqGpz2MO
8Ot7rMYWfQ6lwqnPNtFOMPJhBh4ceQLFz22374o6w/uCs6SQSgOGAp9fuX/P
BTcsB1NDrf5Fnr+Ne+LvbphzOZCSf6MOOnhzsLnNDbmaJkatMrVYyTs11nff
Hcu+GQY5iNfgz0q1oZNuh1GTczHJ3rgKtYWWwgyFIyjmhL8Q45Yj0/ZsRc/g
EZyd9SwxbOCjLfx5688HHth2QP3OLfNSeLlrxIywjsJcKCFIPK0Itrrfj2iY
HINosW+mhlU+Qi6/u9U2fgxZFS9T0h9nQeZ6h68zeRyeL1Q++IqkY1R/NNsp
+AT23DLq7i9KgVLlaeFkhid6uNOz1WpJKBmVmOYt8MKZmVzC2ysOV8qq91rU
eGGt1PL+gvFQvNIK3lkYcxIe9eOvvgfK4JCOS0qclTf2Xw0IqNkTTDJU8mRL
xE4hKf1Ag8ubWDKgeqFeQcsprMkIOOtedp0U+xqWvob7N/atqRgTbr9DTjxd
XH3KiYW53VvNlYofkMnP5qeDVvhAZOP7oK92GaT7pIRFqI8PLMZmXbgZWWTn
tMJhVrsPvNc6Euf08sgfFn/kJRmx8Xdk9foDxoVkhYTsosF4Npq9FfyfPi4i
DdLGDRWn2Ai0uMhOZZWQNhf6uXH2HKzlTNkRE6XkDivuLuODHGSu4iwRni0l
IWki0e3Awb3e2e11Ijxy43VupIYzB2aXUszNpHmkTIZJYPURDo6YsbyIDTyy
6/EVz2EfDvwHrpxUOcwjT4htNbeM4UBPz6Q3solHuj97L/z1Mge2qdtVGa95
pGPs1ZoELgcqZb8Pf3rLI3et+mD67ioHW+dZ0rs+8ki9dfEb/W9ywKhkpEuI
8MkJ849KaekcjPSoibIZfHJkUUL3zkwOFDsa8xUIPvmx8Y9bIw858Lp+VfB4
O5/s3JewaksuB2WyNZ2/2fHJKg/m0lfFHCjYDK0tP8UneZqfnp0u5eBRVYGE
mx+fzB9OiFLkc5AwYHxGPIBPpvh9WuBZzoFLwLsh24t8MomRSEpW0v+J1h6d
4PLJ+BlmcGkVB7fCuUG3r/HJS+SnLY7VHEznKyYQyXwyPCLx53wNB1nbvur3
P+CT/wMknaCB
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  Epilog->{
    PointBox[{34, 33446}], 
    PointBox[{50, 27833}], 
    PointBox[{64, 22960.7}], 
    PointBox[{180, 7619}]},
  Method->{},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"%46", ",", 
   RowBox[{"ImageSize", "\[Rule]", "Full"}]}], "]"}]], "Input",
 NumberMarks->False],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV0Hk01Ykbx3GyVCpRYoYsUZZkiehSc7+fiSRKGaWQrbSQ5rqX0WLNkiQ3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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  Epilog->{
    PointBox[{34, 33446}], 
    PointBox[{50, 27833}], 
    PointBox[{64, 22960.7}], 
    PointBox[{180, 7619}]},
  ImageSize->Full,
  Method->{},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Zus\[ADoubleDot]tzliche Ber\[UDoubleDot]cksichtigung der Trudelphase F.B.s:\
\>", "Section"],

Cell[BoxData[
 RowBox[{
  RowBox[{"s4", ":=", 
   RowBox[{"NDSolve", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"h", "''"}], "[", "t", "]"}], "\[Equal]", 
        RowBox[{
         RowBox[{"-", 
          RowBox[{"greal", "[", 
           RowBox[{"h", "[", "t", "]"}], "]"}]}], "+", 
         RowBox[{
          RowBox[{"dint", "[", 
           RowBox[{
            RowBox[{"h", "[", "t", "]"}], "/", "1000"}], "]"}], "*", 
          RowBox[{
           RowBox[{"h", "'"}], "[", "t", "]"}], "*", 
          RowBox[{
           RowBox[{"h", "'"}], "[", "t", "]"}], "*", "b2", "*", 
          RowBox[{"FSRR", "[", "t", "]"}], "*", 
          RowBox[{"DS", "[", 
           RowBox[{
            RowBox[{"Abs", "[", 
             RowBox[{
              RowBox[{"h", "'"}], "[", "t", "]"}], "]"}], "/", 
            RowBox[{"sint", "[", 
             RowBox[{
              RowBox[{"h", "[", "t", "]"}], "/", "1000"}], "]"}]}], 
           "]"}]}]}]}], ",", 
       RowBox[{
        RowBox[{"h", "[", "0", "]"}], "\[Equal]", "38969"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"h", "'"}], "[", "0", "]"}], "==", "0"}]}], "}"}], ",", "h", 
     ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "1000"}], "}"}]}], "]"}]}], ";"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       RowBox[{"h", "'"}], "[", "t", "]"}]}], "/.", "s4"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "300"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"Epilog", "\[Rule]", 
    RowBox[{"Map", "[", 
     RowBox[{"Point", ",", "speeddata"}], "]"}]}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"InterpolatingFunction", "::", "dmval"}], "MessageName"], ":", 
  " ", "\<\"Input value \[NoBreak]\\!\\({\\(-0.020797016345373207`\\)}\\)\
\[NoBreak] lies outside the range of data in the interpolating function. \
Extrapolation will be used. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/InterpolatingFunction/dmval\\\", \
ButtonNote -> \\\"InterpolatingFunction::dmval\\\"]\\)\"\>"}]], "Message", \
"MSG"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"InterpolatingFunction", "::", "dmval"}], "MessageName"], ":", 
  " ", "\<\"Input value \[NoBreak]\\!\\({\\(-0.020797016345373207`\\)}\\)\
\[NoBreak] lies outside the range of data in the interpolating function. \
Extrapolation will be used. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/InterpolatingFunction/dmval\\\", \
ButtonNote -> \\\"InterpolatingFunction::dmval\\\"]\\)\"\>"}]], "Message", \
"MSG"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"InterpolatingFunction", "::", "dmval"}], "MessageName"], ":", 
  " ", "\<\"Input value \[NoBreak]\\!\\({\\(-0.020797016345373207`\\)}\\)\
\[NoBreak] lies outside the range of data in the interpolating function. \
Extrapolation will be used. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/InterpolatingFunction/dmval\\\", \
ButtonNote -> \\\"InterpolatingFunction::dmval\\\"]\\)\"\>"}]], "Message", \
"MSG"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], ":", 
  " ", "\<\"Further output of \
\[NoBreak]\\!\\(\\*StyleBox[\\(InterpolatingFunction :: dmval\\), \
\\\"MessageName\\\"]\\)\[NoBreak] will be suppressed during this calculation. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/stop\\\", \
ButtonNote -> \\\"General::stop\\\"]\\)\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwNl3k0lesXxynd5CIpTeJKlJCkuLq5fDOdwcE55nkmmc85zjkJpQxlOGRI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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  Epilog->{
    PointBox[{34, 309.72222222222223`}], 
    PointBox[{50, 377.1111111111111}], 
    PointBox[{64, 289.72222222222223`}], 
    PointBox[{180, 79.16666666666667}], 
    PointBox[{260, 53.19444444444445}]},
  Method->{},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"%82", ",", 
   RowBox[{"ImageSize", "\[Rule]", "Full"}]}], "]"}]], "Input",
 NumberMarks->False],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwNl3k0lesXxynd5CIpTeJKlJCkuLq5fDOdwcE55nkmmc85zjkJpQxlOGRI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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  Epilog->{
    PointBox[{34, 309.72222222222223`}], 
    PointBox[{50, 377.1111111111111}], 
    PointBox[{64, 289.72222222222223`}], 
    PointBox[{180, 79.16666666666667}], 
    PointBox[{260, 53.19444444444445}]},
  ImageSize->Full,
  Method->{},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"h", "[", "t", "]"}], "/.", "s4"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "300"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
   RowBox[{"Epilog", "\[Rule]", 
    RowBox[{"Map", "[", 
     RowBox[{"Point", ",", "heightdata"}], "]"}]}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"InterpolatingFunction", "::", "dmval"}], "MessageName"], ":", 
  " ", "\<\"Input value \[NoBreak]\\!\\({\\(-0.020797016345373207`\\)}\\)\
\[NoBreak] lies outside the range of data in the interpolating function. \
Extrapolation will be used. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/InterpolatingFunction/dmval\\\", \
ButtonNote -> \\\"InterpolatingFunction::dmval\\\"]\\)\"\>"}]], "Message", \
"MSG"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"InterpolatingFunction", "::", "dmval"}], "MessageName"], ":", 
  " ", "\<\"Input value \[NoBreak]\\!\\({\\(-0.020797016345373207`\\)}\\)\
\[NoBreak] lies outside the range of data in the interpolating function. \
Extrapolation will be used. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/InterpolatingFunction/dmval\\\", \
ButtonNote -> \\\"InterpolatingFunction::dmval\\\"]\\)\"\>"}]], "Message", \
"MSG"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"InterpolatingFunction", "::", "dmval"}], "MessageName"], ":", 
  " ", "\<\"Input value \[NoBreak]\\!\\({\\(-0.020797016345373207`\\)}\\)\
\[NoBreak] lies outside the range of data in the interpolating function. \
Extrapolation will be used. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/InterpolatingFunction/dmval\\\", \
ButtonNote -> \\\"InterpolatingFunction::dmval\\\"]\\)\"\>"}]], "Message", \
"MSG"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], ":", 
  " ", "\<\"Further output of \
\[NoBreak]\\!\\(\\*StyleBox[\\(InterpolatingFunction :: dmval\\), \
\\\"MessageName\\\"]\\)\[NoBreak] will be suppressed during this calculation. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/stop\\\", \
ButtonNote -> \\\"General::stop\\\"]\\)\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV0Hk01Psfx3GqKS1EC/daCyVcEpFU832VnRJ1U8hWElLMKO32JTFjGBQp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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  Epilog->{
    PointBox[{34, 33446}], 
    PointBox[{50, 27833}], 
    PointBox[{64, 22960.7}], 
    PointBox[{180, 7619}]},
  Method->{},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"%84", ",", 
   RowBox[{"ImageSize", "\[Rule]", "Full"}]}], "]"}]], "Input",
 NumberMarks->False],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV0Hk01Psfx3GqKS1EC/daCyVcEpFU832VnRJ1U8hWElLMKO32JTFjGBQp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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  Epilog->{
    PointBox[{34, 33446}], 
    PointBox[{50, 27833}], 
    PointBox[{64, 22960.7}], 
    PointBox[{180, 7619}]},
  ImageSize->Full,
  Method->{},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1426, 1132},
Visible->True,
ScrollingOptions->{"VerticalScrollRange"->Fit},
PrintingCopies->1,
PrintingPageRange->{1, Automatic},
ShowCellBracket->False,
Deployed->True,
CellContext->Notebook,
TrackCellChangeTimes->False,
FrontEndVersion->"9.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (January 25, \
2013)",
StyleDefinitions->FrontEnd`FileName[{"Creative"}, "NaturalColor.nb", 
  CharacterEncoding -> "UTF-8"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[1485, 35, 103, 2, 61, "Title"],
Cell[CellGroupData[{
Cell[1613, 41, 120, 3, 73, "Section"],
Cell[1736, 46, 2980, 86, 107, "Input"],
Cell[CellGroupData[{
Cell[4741, 136, 65, 1, 38, "Input"],
Cell[4809, 139, 1036, 22, 251, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5894, 167, 135, 3, 73, "Section"],
Cell[6032, 172, 184, 6, 38, "Input"],
Cell[CellGroupData[{
Cell[6241, 182, 281, 8, 38, "Input"],
Cell[6525, 192, 3327, 83, 251, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9901, 281, 80, 2, 73, "Section"],
Cell[CellGroupData[{
Cell[10006, 287, 96, 2, 38, "Input"],
Cell[10105, 291, 230, 8, 38, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10372, 304, 283, 8, 38, "Input"],
Cell[10658, 314, 5092, 112, 251, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15799, 432, 131, 3, 73, "Section"],
Cell[15933, 437, 2815, 85, 90, "Input"],
Cell[CellGroupData[{
Cell[18773, 526, 96, 2, 38, "Input"],
Cell[18872, 530, 230, 8, 38, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[19139, 543, 283, 8, 38, "Input"],
Cell[19425, 553, 8481, 168, 254, "Output"]
}, Open  ]]
}, Open  ]],
Cell[27933, 725, 121, 3, 73, "Section"],
Cell[CellGroupData[{
Cell[28079, 732, 84, 1, 22, "Subsubtitle"],
Cell[28166, 735, 888, 29, 38, "Input"],
Cell[CellGroupData[{
Cell[29079, 768, 169, 5, 38, "Input"],
Cell[29251, 775, 9320, 161, 252, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[38608, 941, 55, 1, 38, "Input"],
Cell[38666, 944, 33, 0, 38, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[38736, 949, 147, 3, 73, "Section"],
Cell[38886, 954, 580, 19, 38, "Input"],
Cell[CellGroupData[{
Cell[39491, 977, 189, 5, 38, "Input"],
Cell[39683, 984, 2221, 46, 257, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[41953, 1036, 76, 2, 73, "Section"],
Cell[42032, 1040, 254, 8, 38, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[42323, 1053, 71, 0, 73, "Section"],
Cell[42397, 1055, 57, 1, 38, "Input"],
Cell[42457, 1058, 83, 2, 38, "Input"],
Cell[42543, 1062, 253, 8, 38, "Input"],
Cell[42799, 1072, 255, 8, 38, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[43091, 1085, 79, 2, 73, "Section"],
Cell[CellGroupData[{
Cell[43195, 1091, 46, 0, 25, "Subsubsection"],
Cell[43244, 1093, 559, 18, 38, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[43840, 1116, 47, 0, 25, "Subsubsection"],
Cell[43890, 1118, 352, 11, 38, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[44291, 1135, 162, 3, 73, "Section"],
Cell[44456, 1140, 948, 29, 38, "Input"],
Cell[CellGroupData[{
Cell[45429, 1173, 445, 13, 38, "Input"],
Cell[45877, 1188, 5526, 99, 247, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[51452, 1293, 167, 3, 73, "Section"],
Cell[51622, 1298, 950, 29, 38, "Input"],
Cell[CellGroupData[{
Cell[52597, 1331, 445, 13, 38, "Input"],
Cell[53045, 1346, 536, 10, 24, "Message"],
Cell[53584, 1358, 536, 10, 24, "Message"],
Cell[54123, 1370, 536, 10, 24, "Message"],
Cell[54662, 1382, 490, 9, 24, "Message"],
Cell[55155, 1393, 6441, 114, 247, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[61633, 1512, 144, 4, 38, "Input"],
Cell[61780, 1518, 6460, 115, 836, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[68289, 1639, 179, 3, 73, "Section"],
Cell[68471, 1644, 1268, 38, 38, "Input"],
Cell[CellGroupData[{
Cell[69764, 1686, 466, 14, 38, "Input"],
Cell[70233, 1702, 537, 10, 24, "Message"],
Cell[70773, 1714, 537, 10, 24, "Message"],
Cell[71313, 1726, 537, 10, 24, "Message"],
Cell[71853, 1738, 490, 9, 24, "Message"],
Cell[72346, 1749, 5851, 104, 247, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[78234, 1858, 144, 4, 38, "Input"],
Cell[78381, 1864, 5870, 105, 836, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[84288, 1974, 358, 6, 55, "Subsection"],
Cell[CellGroupData[{
Cell[84671, 1984, 401, 11, 38, "Input"],
Cell[85075, 1997, 537, 10, 24, "Message"],
Cell[85615, 2009, 537, 10, 24, "Message"],
Cell[86155, 2021, 537, 10, 24, "Message"],
Cell[86695, 2033, 490, 9, 24, "Message"],
Cell[87188, 2044, 3657, 69, 237, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[90882, 2118, 144, 4, 38, "Input"],
Cell[91029, 2124, 3676, 70, 834, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[94766, 2201, 102, 2, 73, "Section"],
Cell[94871, 2205, 1317, 39, 38, "Input"],
Cell[CellGroupData[{
Cell[96213, 2248, 445, 13, 38, "Input"],
Cell[96661, 2263, 537, 10, 24, "Message"],
Cell[97201, 2275, 537, 10, 24, "Message"],
Cell[97741, 2287, 537, 10, 24, "Message"],
Cell[98281, 2299, 490, 9, 24, "Message"],
Cell[98774, 2310, 5904, 105, 247, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[104715, 2420, 144, 4, 38, "Input"],
Cell[104862, 2426, 5923, 106, 836, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[110822, 2537, 401, 11, 38, "Input"],
Cell[111226, 2550, 537, 10, 24, "Message"],
Cell[111766, 2562, 537, 10, 24, "Message"],
Cell[112306, 2574, 537, 10, 24, "Message"],
Cell[112846, 2586, 490, 9, 24, "Message"],
Cell[113339, 2597, 3901, 73, 238, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[117277, 2675, 144, 4, 38, "Input"],
Cell[117424, 2681, 3920, 74, 834, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)

(* NotebookSignature cxDJaJ#qSJW0xB1qFAV@DYuv *)
